import java.awt.geom.Ellipse2D;

/**
 * A circle that can be manipulated and that draws itself on a canvas.
 * 
 * @author  Michael Kolling and David J. Barnes
 * @author  mod.by Denis BUREAU
 * @version 2006.03.30/2007.01.30/2009.09.09
 */

public class Circle
{
    private int     aDiameter;
    private int     aXPosition;
    private int     aYPosition;
    private String  aColor;
    private boolean aIsVisible;
   
    /**
     * Create a new circle at default position with default color.
     */
    public Circle()
    {
        this.aDiameter=  30;
        this.aXPosition= 20;
        this.aYPosition= 60;
        this.aColor=     "blue";
        this.aIsVisible= false;
    } // Circle()

    /**
     * Make this circle visible. If it was already visible, do nothing.
     */
    public void makeVisible()
    {
        this.aIsVisible= true;
        this.draw();
    } // makeVisible()
    
    /**
     * Make this circle invisible. If it was already invisible, do nothing.
     */
    public void makeInvisible()
    {
        this.erase();
        this.aIsVisible= false;
    } // makeInvisible()
    
    /**
     * Move the circle a few pixels to the right.
     */
    public void moveRight()
    {
        this.moveHorizontal(20);
    } // moveRight()

    public void moveLeft()
    {
        this.moveHorizontal(-20);
    } // moveLeft()

    /**
     * Move the circle a few pixels up.
     */
    public void moveUp()
    {
        this.moveVertical(-20);
    } // moveUp()

    public void moveDown()
    {
        this.moveVertical(20);
    } // moveDown()

    /**
     * Move the circle horizontally by 'distance' pixels.
     * @param pDistance nb of pixels to move towards right
     */
    public void moveHorizontal(final int pDistance)
    {
        this.erase();
        this.aXPosition= this.aXPosition + pDistance;
        this.draw();
    } // moveHorizontal()

    public void moveVertical(final int pDistance)
    {
        this.erase();
        this.aYPosition= this.aYPosition + pDistance;
        this.draw();
    } // moveVertical()

    /**
     * Slowly move the shape horizontally by 'pDistance' pixels.
     * @param pDistance nb of pixels to move towards right
     */
    public void slowMoveHorizontal( final int pDistance )
    {
        int vDelta;

        if ( pDistance < 0 ) {
            vDelta=    -1;
        } // if
        else {
            vDelta=    1;
        } // else

        // ecrire ici le deplacement recursif :
        
    } // slowMoveHorizontal()

    public void slowMoveVertical( final int pDistance )
    {
        int vDelta;

        if ( pDistance < 0 ) {
            vDelta=    -1;
        } // if
        else {
            vDelta=    1;
        } // else

        // ecrire ici le deplacement recursif :
        
    } // slowMoveVertical()

    /**
     * Change the size to the new size (in pixels). Size must be >= 0.
     * @param pNewDiameter diameter we want for this circle
     */
    public void changeSize(final int pNewDiameter)
    {
        this.erase();
        this.aDiameter= pNewDiameter;
        this.draw();
    } // changeSize()

    /**
     * Double the size (in pixels).
     */
    public void doubleSize()
    {
        this.erase();
        this.aDiameter= 2 * this.aDiameter;
        this.draw();
    } // doubleSize()

    /**
     * Change the color. Valid colors are "red", "yellow", "blue", "green",
     * "magenta" and "black".
     * @param pNewColor color we want for this circle
     */
    public void changeColor(final String pNewColor)
    {
        this.aColor= pNewColor;
        this.draw();
    } // changeColor()

    /**
     * Draw the circle with current specifications on screen.
     */
    private void draw()
    {
        if (this.aIsVisible) {
            Canvas vCanvas;
            vCanvas= Canvas.getCanvas();
            vCanvas.draw(this, this.aColor,
                         new Ellipse2D.Double(this.aXPosition, this.aYPosition, 
                                              this.aDiameter, this.aDiameter));
            vCanvas.waitALittle();
        } // if
        else {}
    } // draw()

    /**
     * Erase the circle on screen.
     */
    private void erase()
    {
        if (this.aIsVisible) {
            Canvas vCanvas;
            vCanvas= Canvas.getCanvas();
            vCanvas.erase(this);
        } // if
        else {}
    } // erase()
} // Circle
