/**
 * This class represents a simple picture. You can draw the picture using
 * the draw method. But wait, there's more: being an electronic picture, it
 * can be changed. You can set it to black-and-white display and back to
 * colors (only after it's been drawn, of course).
 *
 * This class was written as an early example for teaching Java with BlueJ.
 * 
 * @author  Michael Kolling and David J. Barnes
 * @author  mod.by Denis BUREAU
 * @version 2006.03.30/2010.02.10
 */
public class Picture
{
    private Square   aWall;
    private Square   aWindow;
    private Triangle aRoof;
    private Circle   aSun;
    private boolean  aPlaced;

    /**
     * Constructor for objects of class Picture
     */
    public Picture()
    {
        this.aPlaced= false; // place() is needed
        
        this.aWall= new Square();
        this.aWall.changeSize(100);
        
        this.aWindow= new Square();
        this.aWindow.changeColor("black");

        this.aRoof= new Triangle();  
        this.aRoof.changeSize(50, 140);

        this.aSun= new Circle();
        this.aSun.changeColor("yellow");
        this.aSun.changeSize(60);
        
    } // Picture()

    /**
     * Draw this picture.
     */
    public void draw()
    {
        this.aWall.makeVisible();
        this.aWindow.makeVisible();
        this.aRoof.makeVisible();
        this.aSun.makeVisible();
    } // draw()

    /**
     * Slowly move the elements to their place.
     */
    public void place()
    {
        if ( ! aPlaced ) {
            this.aWall.slowMoveVertical(80);
            this.aWindow.slowMoveHorizontal(20);
            this.aWindow.slowMoveVertical(100);
            this.aRoof.slowMoveHorizontal(60);
            this.aRoof.slowMoveVertical(70);
            this.aSun.slowMoveHorizontal(180);
            this.aSun.slowMoveVertical(-10);
            this.aPlaced= true;
        }
    } // place()

    /**
     * Erase the house from this picture.
     */
    public void eraseHouse()
    {
        this.aWall.makeInvisible();
        this.aWindow.makeInvisible();
        this.aRoof.makeInvisible();
    } // eraseHouse()

    /**
     * Change this picture to black/white display
     */
    public void setBlackAndWhite()
    {
        if (this.aWall != null) { // only if it's painted already...
            this.aWall.changeColor(  "black");
            this.aWindow.changeColor("white");
            this.aRoof.changeColor(  "black");
            this.aSun.changeColor(   "black");
        } // if
        else {}
    } // setBlackAndWhite()

    /**
     * Change this picture to use color display
     */
    public void setColor()
    {
        if (this.aWall != null) { // only if it's painted already...
            this.aWall.changeColor(  "red"   );
            this.aWindow.changeColor("black" );
            this.aRoof.changeColor(  "green" );
            this.aSun.changeColor(   "yellow");
        } // if
        else {}
    } // setColor()
    
} // Picture
