import java.awt.Rectangle;

/**
 * A square that can be manipulated and that draws itself on a canvas.
 * 
 * @author  Michael Kolling and David J. Barnes
 * @author  mod.by Denis BUREAU
 * @version 2006.03.30/2007.01.30/2009.09.09
 */

public class Square
{
    private int     aSize;
    private int     aXPosition;
    private int     aYPosition;
    private String  aColor;
    private boolean aIsVisible;

    /**
     * Create a new square at default position with default color.
     */
    public Square()
    {
        this.aSize=      30;
        this.aXPosition= 60;
        this.aYPosition= 50;
        this.aColor=     "red";
        this.aIsVisible= false;
    } // Square()

    /**
     * Make this square visible. If it was already visible, do nothing.
     */
    public void makeVisible()
    {
        this.aIsVisible= true;
        this.draw();
    } // makeVisible()
    
    /**
     * Make this square invisible. If it was already invisible, do nothing.
     */
    public void makeInvisible()
    {
        this.erase();
        this.aIsVisible= false;
    } // makeInvisible()
    
    /**
     * Move the square a few pixels to the right.
     */
    public void moveRight()
    {
        this.moveHorizontal(20);
    } // moveRight()

    /**
     * Move the square a few pixels to the left.
     */
    public void moveLeft()
    {
        this.moveHorizontal(-20);
    } // moveLeft()

    /**
     * Move the square a few pixels up.
     */
    public void moveUp()
    {
        this.moveVertical(-20);
    } // moveUp()

    /**
     * Move the square a few pixels down.
     */
    public void moveDown()
    {
        this.moveVertical(20);
    } // moveDown()

    /**
     * Move the square horizontally by 'pDistance' pixels.
     */
    public void moveHorizontal(final int pDistance)
    {
        this.erase();
        this.aXPosition= this.aXPosition + pDistance;
        this.draw();
    } // moveHorizontal()

    /**
     * Move the square vertically by 'pDistance' pixels.
     */
    public void moveVertical(final int pDistance)
    {
        this.erase();
        this.aYPosition= this.aYPosition + pDistance;
        this.draw();
    } // moveVertical()

    /**
     * Slowly move the shape horizontally by 'pDistance' pixels.
     * @param pDistance nb of pixels to move towards right
     */
    public void slowMoveHorizontal( final int pDistance )
    {
        int vDelta;

        if ( pDistance < 0 ) {
            vDelta=    -1;
        } // if
        else {
            vDelta=    1;
        } // else

        // ecrire ici le deplacement recursif :
        
    } // slowMoveHorizontal()

    public void slowMoveVertical( final int pDistance )
    {
        int vDelta;

        if ( pDistance < 0 ) {
            vDelta=    -1;
        } // if
        else {
            vDelta=    1;
        } // else

        // ecrire ici le deplacement recursif :
        
    } // slowMoveVertical()

    /**
     * Change the size to the new size (in pixels). Size must be >= 0.
     */
    public void changeSize(final int pNewSize)
    {
        this.erase();
        this.aSize= pNewSize;
        this.draw();
    } // changeSize()

    /**
     * Change the color. Valid colors are "red", "yellow", "blue", "green",
     * "magenta" and "black".
     */
    public void changeColor(final String pNewColor)
    {
        this.aColor= pNewColor;
        this.draw();
    } // changeColor()

    /**
     * Draw the square with current specifications on screen.
     */
    private void draw()
    {
        if (this.aIsVisible) {
            Canvas vCanvas;
            vCanvas= Canvas.getCanvas();
            vCanvas.draw(this, this.aColor,
                         new Rectangle(this.aXPosition, this.aYPosition,
                                       this.aSize, this.aSize));
            vCanvas.waitALittle();
        } // if
        else {}
    } // draw()

    /**
     * Erase the square on screen.
     */
    private void erase()
    {
        if (this.aIsVisible) {
            Canvas vCanvas;
            vCanvas= Canvas.getCanvas();
            vCanvas.erase(this);
        } // if
        else {}
    } // erase()
} // Square
