import java.awt.Polygon;

/**
 * A triangle that can be manipulated and that draws itself on a canvas.
 * 
 * @author  Michael Kolling and David J. Barnes
 * @author  mod.by Denis BUREAU
 * @version 2006.03.30/2007.01.30/2009.09.09
 */

public class Triangle
{
    private int     aHeight;
    private int     aWidth;
    private int     aXPosition;
    private int     aYPosition;
    private String  aColor;
    private boolean aIsVisible;

    /**
     * Create a new triangle at default position with default color.
     */
    public Triangle()
    {
        this.aHeight=    30;
        this.aWidth=     40;
        this.aXPosition= 50;
        this.aYPosition= 15;
        this.aColor=     "green";
        this.aIsVisible= false;
    } // Triangle()

    /**
     * Make this triangle visible. If it was already visible, do nothing.
     */
    public void makeVisible()
    {
        this.aIsVisible = true;
        this.draw();
    } // makeVisible()
    
    /**
     * Make this triangle invisible. If it was already invisible, do nothing.
     */
    public void makeInvisible()
    {
        this.erase();
        this.aIsVisible = false;
    } // makeInvisible()
    
    /**
     * Move the triangle a few pixels to the right.
     */
    public void moveRight()
    {
        this.moveHorizontal(20);
    } // moveRight()

    /**
     * Move the triangle a few pixels to the left.
     */
    public void moveLeft()
    {
        moveHorizontal(-20);
    } // moveLeft()

    /**
     * Move the triangle a few pixels up.
     */
    public void moveUp()
    {
        this.moveVertical(-20);
    } // moveUp()

    /**
     * Move the triangle a few pixels down.
     */
    public void moveDown()
    {
        this.moveVertical(20);
    } // moveDown()

    /**
     * Move the triangle horizontally by 'pDistance' pixels.
     */
    public void moveHorizontal(final int pDistance)
    {
        this.erase();
        this.aXPosition= this.aXPosition + pDistance;
        this.draw();
    } // moveHorizontal()

    /**
     * Move the triangle vertically by 'pDistance' pixels.
     */
    public void moveVertical(final int pDistance)
    {
        this.erase();
        this.aYPosition= this.aYPosition + pDistance;
        this.draw();
    } // moveVertical()

    /**
     * Slowly move the shape horizontally by 'pDistance' pixels.
     * @param pDistance nb of pixels to move towards right
     */
    public void slowMoveHorizontal( final int pDistance )
    {
        int vDelta;

        if ( pDistance < 0 ) {
            vDelta=    -1;
        } // if
        else {
            vDelta=    1;
        } // else

        // ecrire ici le deplacement recursif :
        
    } // slowMoveHorizontal()

    public void slowMoveVertical( final int pDistance )
    {
        int vDelta;

        if ( pDistance < 0 ) {
            vDelta=    -1;
        } // if
        else {
            vDelta=    1;
        } // else

        // ecrire ici le deplacement recursif :
        
    } // slowMoveVertical()

    /**
     * Change the size to the new size (in pixels). Size must be >= 0.
     */
    public void changeSize(final int pNewHeight, final int pNewWidth)
    {
        this.erase();
        this.aHeight= pNewHeight;
        this.aWidth=  pNewWidth;
        this.draw();
    } // changeSize()

    /**
     * Change the color. Valid colors are "red", "yellow", "blue", "green",
     * "magenta" and "black".
     */
    public void changeColor(final String pNewColor)
    {
        this.aColor= pNewColor;
        this.draw();
    } // changeColor()

    /**
     * Draw the triangle with current specifications on screen.
     */
    private void draw()
    {
        if (this.aIsVisible) {
            Canvas vCanvas;
            vCanvas= Canvas.getCanvas();
         // int[] is a special java type to be explained later
            int[] xpoints ={ this.aXPosition, this.aXPosition + (this.aWidth/2), this.aXPosition - (this.aWidth/2) };
            int[] ypoints ={ this.aYPosition, this.aYPosition + this.aHeight,    this.aYPosition + this.aHeight    };
            vCanvas.draw(this, this.aColor, new Polygon(xpoints, ypoints, 3));
            vCanvas.waitALittle();
        } // if
        else {}
    } // draw()

    /**
     * Erase the triangle on screen.
     */
    private void erase()
    {
        if (this.aIsVisible) {
            Canvas vCanvas;
            vCanvas= Canvas.getCanvas();
            vCanvas.erase(this);
        } // if
        else {}
    } // erase()
} // Triangle
